<?php
/**
 * Logs
 *
 * @package     AutomatorWP\Schedule_Actions\Logs
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register custom log types
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_schelude_actions_log_types( $log_types ) {

    $log_types['schedule_actions'] = __( 'Scheduled', 'automatorwp-pro' );

    return $log_types;

}
add_filter( 'automatorwp_log_types', 'automatorwp_schelude_actions_log_types' );

/**
 * Columns rendering for logs list view
 *
 * @since  1.0.0
 *
 * @param string $column_name
 * @param integer $object_id
 */
function automatorwp_schedule_actions_manage_logs_custom_column( $column_name, $object_id ) {

    if( $column_name !== 'object_id' ) {
        return;
    }

    // Setup vars
    $log = ct_get_object( $object_id );

    if( $log->type !== 'schedule_actions' ) {
        return;
    }

    // Get the action assigned to log
    $action = automatorwp_get_action_object( $log->object_id );
    $automation = false;

    if( $action ) {
        // Get the action's automation
        $automation = automatorwp_get_automation_object( $action->automation_id );
    }

    // if automation found, render it's title
    if( $automation ) {

        $title = ! empty( $automation->title ) ? $automation->title : __( '(No title)', 'automatorwp' ); ?>
        <a href="<?php echo ct_get_edit_link( 'automatorwp_automations', $automation->id ); ?>"><?php echo $title; ?></a>
        <?php

    } else {
        echo '&nbsp;';
    }

}
add_action( 'manage_automatorwp_logs_custom_column', 'automatorwp_schedule_actions_manage_logs_custom_column', 5, 2 );

/**
 * Custom log default icon
 *
 * @since 1.0.0
 *
 * @param string    $icon   The icon URL
 * @param stdClass  $log    The log object
 *
 * @return string
 */
function automatorwp_schedule_actions_get_log_default_icon( $icon, $log ) {

    if( $log->type !== 'schedule_actions' ) {
        return $icon;
    }

    $icon = AUTOMATORWP_SCHEDULE_ACTIONS_URL . 'assets/schedule-actions.svg';

    return $icon;

}
add_filter( 'automatorwp_get_log_default_icon', 'automatorwp_schedule_actions_get_log_default_icon', 10, 2 );

/**
 * Custom log default icon title
 *
 * @since 1.0.0
 *
 * @param string    $title  The icon title attribute
 * @param stdClass  $log    The log object
 *
 * @return string
 */
function automatorwp_schedule_actions_get_log_default_icon_title( $title, $log ) {

    if( $log->type !== 'schedule_actions' ) {
        return $title;
    }

    $title = 'AutomatorWP - Schedule Actions';

    return $title;

}
add_filter( 'automatorwp_get_log_default_icon_title', 'automatorwp_schedule_actions_get_log_default_icon_title', 10, 2 );
